/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.secrets_of_forging_revelations.effects;

import net.acetheeldritchking.secrets_of_forging_revelations.effects.potion.PotionEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterDecimal;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;

public class BlizzardEffect {
    private static final ItemEffect blizzardEffect = ItemEffect.get((String)"secrets_of_forging_revelations:blizzard");

    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        StatGetterEffectLevel effectStatGetter = new StatGetterEffectLevel(blizzardEffect, 1.0);
        GuiStatBar effectBar = new GuiStatBar(0, 0, 59, "secrets_of_forging_revelations.effect.blizzard.name", 0.0, 30.0, false, (IStatGetter)effectStatGetter, LabelGetterBasic.decimalLabel, (ITooltipGetter)new TooltipGetterDecimal("secrets_of_forging_revelations.effect.blizzard.tooltip", (IStatGetter)effectStatGetter));
        WorkbenchStatsGui.addBar((GuiStatBase)effectBar);
        HoloStatsGui.addBar((GuiStatBase)effectBar);
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        Item item;
        Player player = event.player;
        ItemStack heldStack = player.m_21205_();
        if (player.f_19797_ % 20 == 0 && (item = heldStack.m_41720_()) instanceof ModularItem) {
            ModularItem item2 = (ModularItem)item;
            int level = item2.getEffectLevel(heldStack, blizzardEffect);
            int eff = (int)item2.getEffectEfficiency(heldStack, blizzardEffect);
            BlockPos pos = player.m_20183_();
            boolean coldEnoughToSnow = ((Biome)player.f_19853_.m_204166_(pos).m_203334_()).m_198904_(pos);
            boolean tooWarm = ((Biome)player.f_19853_.m_204166_(pos).m_203334_()).m_198906_(pos);
            if (level > 0 && !player.f_19853_.m_5776_()) {
                if (coldEnoughToSnow) {
                    this.grantBuffs(player, eff, level);
                } else if (tooWarm) {
                    this.grantDebuffs(player, eff, level);
                }
                if (player.m_21023_((MobEffect)PotionEffects.FREEZING.get())) {
                    player.m_21195_((MobEffect)PotionEffects.FREEZING.get());
                }
            }
        }
    }

    private void grantBuffs(Player player, int duration, int level) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, duration * 20, level - 1, true, true, true));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, duration * 20, level - 1, true, true, true));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration * 20, level - 1, true, true, true));
    }

    private void grantDebuffs(Player player, int duration, int level) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration * 20, level, true, true, true));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration * 20, level, true, true, true));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, duration * 20, level, true, true, true));
    }
}

